CREATE OR REPLACE FUNCTION addColumn() 
RETURNS VOID AS 
$BODY$ 
BEGIN 
    IF EXISTS (SELECT 1 FROM information_schema.columns 
                    WHERE table_name= 'v_nfce_venda') THEN 
		DROP VIEW v_nfce_venda;
        RAISE NOTICE 'v_nfce_venda Dropada.';
    END IF;
	
	CREATE OR REPLACE VIEW public.v_nfce_venda
	AS SELECT cp.cd_emp,
	    cp.cd_filial,
	    cp.cd_cx,
	    cp.cd_vd,
	    cp.dt_vd AS dt_cupom,
	    cp.nr_ecf,
	    cp.cd_cli,
	    cp.cgc_cpf,
	    cp.nm_cli,
	    cp.vlr_desc AS vl_desc_vd,
	    cp.vlr_dinh AS vl_dinh,
	    cp.vlr_chqs AS vl_chqs,
	    ( SELECT COALESCE(sum(item.vl_cartao), 0::numeric) AS "coalesce"
	           FROM pdv_vd_tef item
	          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd) AS vl_cartao,
	    ( SELECT COALESCE(sum(item.vl_parc), 0::numeric) AS "coalesce"
	           FROM pdv_vd_cred item
	          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd) AS vl_crediario,
	    cp.vlr_tickets AS vl_tickets,
	    cp.vlr_conv AS vl_conv,
	    cp.vlr_dup AS vl_dup,
	    cp.vlr_ncc,
	    cp.st_vd AS st_cupom,
	    cp.vlr_conv_pbm,
	    cp.vlr_tot_prod AS vl_to_liq_it,
	    cp.vlr_liq_vd AS vl_to_liq_vd,
	    cp.vlr_vd AS vl_to_bruto_it,
	    it.cd_it,
	    COALESCE(it.cd_barras, '0'::character varying)::text AS ean,
	    it.cd_prod,
	    p.ds_prod,
	    p.ncm_prod,
	    0 AS ean_trib,
	    medidas.ds_un AS cd_un_vd,
	    it.qt_it,
	    it.vlr_it AS vl_unit,
	    it.qt_it * it.vlr_it AS vl_to_it,
	    it.qt_it * it.vlr_it - it.vlr_tot_it AS vl_desc_it,
	    it.vlr_tot_it AS vl_liq_it,
	    it.cd_trib_fc,
	    it.tx_icms_it,
	    it.tx_red_it,
	    it.st_it AS sts_prod,
	    it.tipo_imposto,
	    cp.cd_nf_serie,
	    cp.vlr_imposto,
	    cp.tx_med_imposto,
	    coalesce(it.perc_red_base_calc_efet,0) as perc_red_base_calc_efet_it,
		coalesce(it.perc_icms_efet,0) as perc_icms_efet_it,
		coalesce(IT.VLR_BASE_CALC_EFET,0) as VLR_BASE_CALC_EFET_IT,
		coalesce(IT.VLR_ICMS_EFET,0) as VLR_ICMS_EFET_IT,
		coalesce(CP.VLR_BASE_CALC_EFET ,0) as VLR_BASE_CALC_EFET_CAB,
		coalesce(CP.VLR_EFET_ICMS,0) as VLR_EFET_ICMS_CAB
	   FROM pdv_vd cp
	     JOIN pdv_vd_it it ON cp.cd_emp = it.cd_emp AND cp.cd_filial = it.cd_filial AND cp.cd_vd = it.cd_vd
	     JOIN est_prod p ON it.cd_emp = p.cd_emp AND it.cd_prod = p.cd_prod
	     LEFT JOIN est_prod_un_med medidas ON p.cd_emp = medidas.cd_emp AND p.cd_un_vd = medidas.cd_ctr_un;
		 
	RAISE NOTICE 'v_nfce_venda Recriada.';
       
END; 
-- fim bloco principal 
$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION addColumn() OWNER TO postgres; 
SELECT addColumn(); 
DROP FUNCTION addColumn();












